---
module: Cognitie en kunstmatige intelligentie
---

## Hoofdleerdoelen

Na het afronden van deze cursus kun je
1. uitleggen wat het [[cognitivisme]] inhoudt en op welke ontwikkelingen binnen de AI en filosofie deze theoretische stroming is gebaseerd
2. in hoofdlijnen de werking van connectionistische netwerkmodellen uitleggen, de eigenschappen van neurale netwerken omschrijven en de verschillen duiden tussen GOFAI en connectionistische modellen
3. verwoorden wat de wetenschappelijke status is van de *folk psychology* volgens Fodor en de Churchlands, en kun je het nut van de *intentional stance* van Dennett uitleggen en relateren aan opvattingen binnen de *folk psychology*
4. de basisprincipes uitleggen van perceptuele-controletheorie (PCT) en deze benadering contrasteren met andere benaderingen die in deze cursus aan bod komen
5. het verschil uitleggen tussen het klassieke *sense-model-plan-act-model en de subsumptie-architectuur
6. de belangrijkste ideeën en kernconcepten (zoals zelforganisatie en morfologische computatie) binnen de *bottom-up* benadering van *Artificial Life* (*ALife*) en *Soft Robotics* uitleggen en contrasteren met traditionele *top-down* benaderingen in AI en cognitiewetenschappen
7. de belangrijkste thema’s binnen het onderzoeksveld mens-computerinteractie uitleggen, voorbeelden noemen van praktische toepassingen die relevant zijn voor de psychologie en casestudies vanuit verschillende theoretische perspectieven beschouwen
8. de basisbegrippen uit de dynamische systeemtheorie uitleggen en toepassen en verwoorden hoe de dynamische systeembenadering van cognitie zich verhoudt tegenover het cognitivisme, connectionisme en belichaamde/gesitueerde cognitie
9. ideeën over de *extended mind* kritisch beschouwen en afzetten tegen de verschillende theorieën die in deze cursus aan bod komen
10. in grote lijnen de theorie van *predictive coding* uitleggen en specificeren hoe deze theorie verbonden kan worden met ideeën uit de belichaamde/gesitueerde cognitie.

Achtergrondinformatie: [[De oorsprong van de computerwetenschappen]]


## Leerdoelen

[[1.1 Leerdoelen cognitvisme]] 
- uitleggen welke factoren bijdroegen aan de opkomst van het [[cognitivisme]] [[1.1.0.1]]
- de vier eigenschappen en belangrijkste tekortkomingen van het [[machinefunctionalisme]] uitleggen (of wordt hier de [[kenmerken en beperkingen machinefunctionalisme]] bedoeld?) [[1.1.0.2]]
- het *[[Sense-plan-act model]]* omschrijven en relateren aan het cognitivisme [[1.1.0.3]]
- reflecteren op de aard en beperkingen van de [[Turing-test]]. [[1.1.0.4]]

[[1.2 Leerdoelen symbolische AI]]
- de *[[Physical Symbol System Hypothesis]]* (PSSH) uitleggen en kun je onder woorden brengen uit welke twee onderdelen de PSSH bestaat
- de belangrijkste aspecten en tekortkomingen *Good Old Fashioned Artificial Intelligence* ([[GOFAI]]) verwoorden
- het *[[frame problem]]* van AI verwoorden zoals dat door Daniel Dennett is geformuleerd
- uitleggen wat het gedachtenexperiment '[[Chinese kamer-experiment|de Chinese kamer]]' van Searle inhoudt, en kun je ook kritieken op dit gedachtenexperiment beschouwen.

[[1.3 Leerdoelen intentional stance]]
- uitleggen welke *visie* Fodor, Churchland en Dennett hebben op de rol van folk psychology en intentionele termen bij het verklaren van gedrag
- de termen ‘[[propositionele attitudes]]’, ‘[[folk psychology]] / common sense psychology’ uitleggen
- omschrijven hoe Dennett, met behulp van de *[[intentional stance]]*, een verklaring biedt voor het succes van folk psychology
- het onderscheid tussen *abstracta* en *concreta* aangeven
- het verschil tussen *ungrounded* and *scattered* mental causation uitleggen en waarom de eerste problematisch is volgens Clark.

[[1.4.0 Het Computationele Brein -  Cognitie]] 
- de globale werking van een perceptron omschrijven en kun je uitleggen wat de beperkingen van deze modellen zijn
- de belangrijkste eigenschappen van [[ANNs]] uitleggen, zoals *graceful degradation*, *pattern completion,* gedistribueerde representatie en *superpositional coding*
- kun je omschrijven in hoeverre ANNs biologisch en psychologisch plausibel zijn
- kun je de belangrijkste verschillen tussen GOFAI en ANNs tegen elkaar afzetten.

 [[2.5.0 Brein, Lichaam en Omgeving - Perceptual Control Theory]]
- de belangrijkste begrippen uit de PCT (controle, conflict, reorganisatie) uit te leggen
- controle van perceptie in levende organismen uit te leggen aan de hand van alledaagse homeostatische systemen, zoals de thermostaat
- alledaagse voorbeelden te noemen van variabelen die je zelf onder controle houdt en voorbeelden geven van verstoringen van die variabelen
- het verschil tussen PCT en het stimulus-responsmodel en de cognitieve theorie uit te leggen
- met enkele voorbeelden uit te leggen hoe men PCT gebruikt om psychopathologie te verklaren als controle van perceptie.

[[2.6.0 Brein, Lichaam en Omgeving - Perceptie en actie]]
- uitleggen hoe de drie analyseniveaus van David Marr terugkomen in zijn theorie over visuele waarneming en hoe deze theorie zich verhoudt tot het *sense-plan-act*-model
- aangeven op welke manieren neurowetenschappelijk onderzoek over de relatie tussen perceptie en actie (zoals *change blindness*) het *sense-model-plan-act-*model ondermijnt
- globaal uitleggen wat een subsumptiearchitectuur is en op welke manier het een alternatief biedt voor het *sense-model-plan-act-*model
- de *bottom-up-*benadering van Brooks contrasteren met de traditionele *top-down-*benadering van GOFAI.

[[2.7.0 Brein, Lichaam en Omgeving - Artificial life]]
- uitleggen hoe brein-lichaam-omgevingsinteracties bijdragen aan de totstandkoming van adaptief gedrag
- analyseren en vergelijken van de bottom-up benadering van *Artificial Life*(*ALife*) met traditionele top-down benaderingen in AI en cognitiewetenschappen
- definiëren en toepassen van kernconcepten binnen *ALife*, zoals zelforganisatie, emergentie, en stigmergetische routines
- beschrijven en uitleggen van de principes van *soft robotics*, zoals morfologische computatie, en uitleggen hoe deze verschillen van traditionele robotica (GOFAI)
- evalueren van de sterke punten en beperkingen van *ALife*-benaderingen bij het verklaren van complexe cognitieve taken, zoals abstract redeneren
- beschrijven hoe inzichten uit *ALife* en *soft robotics* kunnen worden toegepast om menselijke cognitie te begrijpen.

[[3.8.0 Mens en Machine - Introductie in mens-machine-interactie]]
- te beschrijven wat de focus is van het onderzoek naar mens-robotinteractie
- te beschrijven welke academische disciplines samenkomen in het onderzoek naar mens-robotinteractie en wat barrières en facilitators voor samenwerking zijn
- de geschiedenis van het onderzoek naar mens-robotinteractie te beschrijven
- factoren die een belangrijke rol spelen bij het ontwerpen van robots te benoemen en toe te lichten
- belangrijke ontwerpprincipes in mens-robotinteractie te benoemen en toe te lichten
- uit te leggen wat antropomorfisme betekent en toe te lichten welke rol antropomorfisme speelt bij het ontwerpen van robots en mens-robotinteractie
- drie factoren te benoemen en toe te lichten die antropomorfistische inferenties over niet-menselijke entiteiten bepalen
- Mori’s theorie over de *uncanny valley* uit te leggen
- uit te leggen hoe antropomorfisme gemeten kan worden
- een link te leggen tussen antropomorfisme en literatuur uit eerdere thema's
- de opgedane kennis toe te passen op een concrete casus.

[[3.9.0 Mens en Machine - Mens-machine-interactie en de toekomst van werk]]
- te beschrijven hoe werk verandert onder de invloed van technologische innovaties en uit te leggen wat voor potentiële consequenties dit heeft voor de bevrediging van psychologische basisbehoeften en motivatie van werknemers
- toe te lichten welke rollen onzekerheid en interdependentie spelen in relatie tot nieuwe technologieën en de toekomst van werk
- voorbeelden te geven van werk dat momenteel al beïnvloed wordt door technologische vernieuwingen
- toe te lichten welke rol zelf-determinatietheorie kan spelen bij het ontwerpen en implementeren van nieuwe technologieën op de werkvloer
- een link te leggen tussen zelf-determinatietheorie en literatuur uit eerdere thema’s
- de opgedane kennis toe te passen op een concrete casus.

[[3.10.0 Mens en Machine - Virtual reality, perceptie en emoties]]
- de begrippen virtual reality, *presence* en *immersion* uit te leggen [[3.10.0.1]]
- de verbanden tussen presence, immersion en emotionele reacties onder woorden te brengen [[3.10.0.2]]
- uit te leggen welke voordelen virtual reality biedt voor onderzoek naar perceptie en emotie [[3.10.0.3]]
- factoren te benoemen die van invloed zijn op de emotionele respons in virtual reality [[3.10.0.4]]
- concepten uit deze cursus met betrekking tot perceptie toe te passen op de vormgeving van een virtuele omgeving om emoties op te roepen
- uit te leggen welke voordelen virtual reality biedt voor mensen met mentale klachten (zoals angstklachten)
- een link te leggen tussen perceptie en emotie in virtual reality en theorieën uit eerdere thema’s.

[[4.11.0 Moderne cognitiewetenschap - dynamische systeemtheorie]]
- de belangrijkste basisbegrippen uit de ==dynamische systeem**theorie**== (DST) uitleggen [[4.11.0.1]]
- de ==dynamische systeem**hypothese**== van cognitie in hoofdlijnen uitleggen en contrasteren met andere benaderingen die in deze cursus aan de orde komen [[4.11.0.2]]
- de principes van de dynamische systeemtheorie toepassen op ontwikkelingspsychologische fenomenen en uitleggen hoe deze benadering verschilt van traditionele verklaringen [[4.11.0.3]]
- de kernprincipes van de complexiteitstheorie van psychopathologie beschrijven en de implicaties duiden van deze benadering voor classificatie, interventie en onderzoek in de klinische psychologie. [[4.11.0.4]]

→ [[dynamische systeemhypothese versus dynamische systeemtheorie]]

[[4.12.0 Moderne cognitiewetenschap - Cognitieve technologie]]
- het concept van de *extended mind* uitleggen en beargumenteren hoe door middel van *scaffolding* externe hulpmiddelen en technologieën een integraal onderdeel kunnen worden van onze cognitieve processen [[4.12.0.1]]
- de potentiële effecten van intensief internetgebruik op aandacht, geheugen en sociale cognitie beschrijven, en daarbij de huidige stand van wetenschappelijk onderzoek op dit gebied globaal weergeven [[4.12.0.2]]
- de belangrijkste bevindingen uit wetenschappelijk onderzoek naar de invloed van smartphones op cognitieve functies zoals aandacht, geheugen en uitstel van beloning samenvatten en de beperkingen van het huidige onderzoek op dit gebied benoemen [[4.12.0.3]]
- de zes belangrijkste claims over belichaamde cognitie zoals beschreven door Wilson samenvatten en de empirische plausibiliteit van elk van deze claims kunnen evalueren. [[4.12.0.4]]

→ [[Hoe kunnen we deze inzichten gebruiken om cognitieve problemen, zoals starre denkpatronen of cognitieve beperkingen, beter te behandelen of te ondersteunen?]]

[[4.13.0 Moderne cognitiewetenschap - Het voorspellende brein]]
- de kernprincipes en kernbegrippen van [[009 De opslagschuur/Glossary/predictive processing|predictive processing]] omschrijven en in (grote lijnen) uitleggen hoe *[[hierarchical predictive processing]]* werkt 
- uitleggen hoe [[Bayes regel]] een computationele beschrijving biedt van hoe het brein tot voorspellingen zou kunnen komen op basis van bestaande kennis  [[4.13.0.2]]
- uitleggen hoe predictive processing perceptie, actie en cognitie integreert binnen één overkoepelend raamwerk [[4.13.0.3]]
- het concept van het brein als voorspellende machine toepassen om de symptomen van autisme te verklaren [[4.13.0.4]] ([[schizofrenie en predictive processing]], [[dementie en het voorspellende brein]])
- de predictive-processingbenadering vergelijken en contrasteren met andere benaderingen, zoals symbolische AI, connectionisme en belichaamde cognitie [[4.13.0.5]]
- enkele (mogelijke) problemen en tekortkomingen rondom het *predictive processing-* raamwerk benoemen. [[4.13.0.6]]


→ [[Overkoepelende processen in cognitie - wat, waarom en hoe?]]
→ [[De complexe verwevenheid van lichaam, omgeving, actie en technologie met cognitie]]
→ [[We controleren ons gedrag vooral om onze waarnemingen te controleren, niet andersom]]


# Totaaloverzicht

| Thema koffiezetapparatententententoonstellingsruimte                                                                                                                                                                                                                                                                                                                                                              | Taak                                                                                                                                                                                                        |
| ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **1. Het computationele brein**                                                                                                                                                                                                                                                                                                                                                                                   | *focust op computationele modellen van cognitie en modellen*                                                                                                                                                |
| [[1.1.0 Het Computationele Brein - Cognitivisme]] <br>[[1.1.1 Opdracht Formle logica en Türing-machines]]<br>[[1.1.2 Opdracht sense-plan-act]]<br>[[1.1.3 Opdrachten Türing-test]]                                                                                                                                                                                                                                | 1. [[cognitivisme]]: de theorie dat mentale processen zoals denken en leren te begrijpen zijn als informatieverwerking, vergelijkbaar met computerprogramma's.                                              |
| [[1.2.0 Het Computationele Brein - Symbolische AI]]<br>[[1.2.1 Opdrachten De Physical Symbol System Hypothesis]]<br>[[1.2.2 Opdracht Shakey de Robot]]<br>[[1.2.3 Opdrachten The Chinese Room]]                                                                                                                                                                                                                   | 2. Symbolische AI: kunstmatige intelligentie gebaseerd op het manipuleren van symbolen volgens regels, waarbij kennis expliciet wordt gerepresenteerd. ([[Symbolische verwerking]], [[symbolische logica]]) |
| [[1.3.0 Het Computationele Brein - De intentional stance]]<br>[[1.3.1 Opdracht Propositionele attitudes]]<br>[[1.3.2 Opdracht Fodors realisme en Churchlands eliminativisme]]<br>[[1.3.3 Opdracht Dennetts milde realisme]]                                                                                                                                                                                       | 3. De [[intentional stance]]: een concept van [[Daniel Dennett]] dat beschrijft hoe we gedrag van systemen of individuen begrijpen door intenties toe te schrijven.                                         |
| [[1.4.0 Het Computationele Brein -  Cognitie]]<br>[[1.4.1 Opdracht Het Rosenblatt perceptron]]<br>[[1.4.2 Opdracht backpropagation en patroonherkenning]]<br>[[1.4.3 Opdracht NETtalk]]<br>[[1.4.4 Opdracht ANN's]]                                                                                                                                                                                               | 4. [[connectionisme]]: een benadering die cognitieve processen modelleert met neurale netwerken, waarin kennis ligt opgeslagen in patronen van verbindingen tussen knopen.                                  |
| **2. Brein, lichaam & omgeving**                                                                                                                                                                                                                                                                                                                                                                                  | *benadrukt de rol van interacties tussen brein, lichaam en omgeving*                                                                                                                                        |
| [[2.5.0 Brein, Lichaam en Omgeving - Perceptual Control Theory]]<br>[[2.5.1 Opdracht controlesysteem]]<br>[[2.5.2 Opdracht Control Theory en PCT]]<br>[[2.5.3 Opdracht PCT en Psychopathologie]]<br>                                                                                                                                                                                                              | 5. Perceptual Control Theory: een theorie die gedrag beschrijft als het continu controleren van percepties om doelen te bereiken.                                                                           |
| [[2.6.0 Brein, Lichaam en Omgeving - Perceptie en actie]]<br>[[2.6.1 Opdracht David Marr]]<br>[[2.6.2 Opdracht Sense-plan-act model]]<br>[[2.6.3 Opdracht Action-based robotics en Rodney Brooks]]                                                                                                                                                                                                                | 6. Perceptie & Actie: : de wisselwerking tussen waarneming en beweging in het begrijpen en beïnvloeden van de omgeving.                                                                                     |
| [[2.7.0 Brein, Lichaam en Omgeving - Artificial life]]<br>[[2.7.1 Opdracht Andy Clark en Barbara Webb]]<br>[[2.7.2 Opdracht Zelforganisatie]]<br>[[2.7.3 Opdracht Soft robotics]]                                                                                                                                                                                                                                 | 7. Artificial Life: een onderzoeksgebied gericht op het modelleren van biologische processen in kunstmatige systemen.                                                                                       |
| **3. Mens en machine**                                                                                                                                                                                                                                                                                                                                                                                            | *richt zich op praktische toepassingen en implicaties van mens-machine-interactie*                                                                                                                          |
| [[3.8.0 Mens en Machine - Introductie in mens-machine-interactie]]<br>[[3.8.1 Opdracht mens-robot-interactie]]<br>[[3.8.2 Opdracht social en humanoid robots]]<br>                                                                                                                                                                                                                                                | 8. Introductie in Mens-Machine interactie: de studie van hoe mensen en machines samenwerken, en hoe technologie kan worden ontworpen om gebruiksvriendelijk te zijn.                                        |
| [[3.9.0 Mens en Machine - Mens-machine-interactie en de toekomst van werk]]<br>[[3.9.1 Opdracht SDT en technostress]]<br>[[3.9.2 Opdracht Robotisering en de zelf-determinatietheorie]]                                                                                                                                                                                                                           | 9. MMI en de Toekomst van Werk: hoe de opkomst van technologie zoals AI de manier van werken verandert en ethische uitdagingen creëert.                                                                     |
| [[3.10.0 Mens en Machine - Virtual reality, perceptie en emoties]]<br>[[3.10.1 Opdracht Artikel van Diemer et al]]<br>[[3.10.2 Opdracht Virtual reality, experimentele controle en ecologische validiteit]]<br>[[3.10.2 Opdracht Virtual reality, experimentele controle en ecologische validiteit]]<br>[[3.10.3 Opdracht Presence, immersion en emotionele reacties]]<br>[[3.10.4 Opdracht exposurebehandeling]] | 10. Virtual Reality, Perceptie en Emoties: hoe virtuele omgevingen perceptie en emoties beïnvloeden, en toepassingen zoals training of therapie.                                                            |
| **4. Moderne cognitiewetenschap**                                                                                                                                                                                                                                                                                                                                                                                 | *behandelt moderne theoretische en technologische vooruitgangen in cognitiewetenschap*                                                                                                                      |
| [[4.11.0 Moderne cognitiewetenschap - dynamische systeemtheorie]]<br>[[4.11.1 Opdracht Dynamische systeemtheorie]]<br>[[4.11.2 Opdracht Dynamische systeembenadering in de cognitiewetenschap]]<br>[[4.11.3 Opdracht De A-niet-B-fout]]<br>[[4.11.4 Opdracht Complexity theory of psychopathology]]                                                                                                                                                          | 11. Dynamische systeemtheorie: een benadering die cognitie beschrijft als een emergent fenomeen uit de interactie tussen complexe systemen.                                                                 |
| [[4.12.0 Moderne cognitiewetenschap - Cognitieve technologie]]<br>[[4.12.1 Opdracht Extended Mind]]<br>[[4.12.2 Opdracht Intensief internet- en smartphonegebruik]]<br>[[4.12.3 Opdracht Six Views of Embodied Cognition]]                                                                                                                                                                                        | 12. Cognitieve technologie: technologieën die zijn ontworpen om menselijke cognitieve vermogens te ondersteunen of uit te breiden.                                                                          |
| [[4.13.0 Moderne cognitiewetenschap - Het voorspellende brein]]<br>[[4.13.1 Opdracht Predictive Processing]]<br>[[4.13.2 Opdracht autisme en het voorspellende brein]]<br>[[4.13.3 Opdracht kritieken en beperkingen predictive processing]]                                                                                                                                                                      | 13. Het voorspellende brein: een model waarin het brein voortdurend voorspellingen maakt over de wereld en deze bijstuurt op basis van waarneming.                                                          |
|                                                                                                                                                                                                                                                                                                                                                                                                                   |                                                                                                                                                                                                             |


# TOC

-  [[MOC studietaken OU]]
- [[1.1 Leerdoelen cognitvisme]]
- [[1.2 Leerdoelen symbolische AI]]
- [[1.3 Leerdoelen intentional stance]]
- [[1.4 Leerdoelen cognitie]]
- [[2.5 Leerdoelen PCT]]
- [[2.6 Leerdoelen Brein, Lichaam en Omgeving - Perceptie en actie]]
- [[2.7 Leerdoelen Brein, lichaam en omgeving - Artificial life]]
- [[3.8 Leerdoelen Mens en Machine - Introductie in mens-machine-interactie]]
- [[3.9 Leerdoelen mens-machine-interactie en de toekomst van werk]]
- [[3.10 Leerdoelen Virtual Reality, perceptie en emoties]]
- [[4.11 Leerdoelen Moderne cognitiewetenschap - Dynamische systeemtheorie]]
- [[4.12 Leerdoelen cognitieve technologie (wideware) en de extended mind]]
- [[4.13 Het voorspellende brein - een predictive processing perspectief]]